###################################################
### chunk number 1: moneda
###################################################
set.seed(123)
volado<-rbinom(8,1,0.5)
volado


###################################################
### chunk number 2: moneda.matriz
###################################################
mat.vol<-matrix(rep(0,80000),10000,8)
for(i in 1:10000){
mat.vol[i,] <- rbinom(8,1,0.5)
}


###################################################
### chunk number 3: 3.contando.aguilas
###################################################
suma <- apply(mat.vol,1,sum)
agui.esp <- mean(suma)
agui.esp


###################################################
### chunk number 4: 4.prob de recaptura
###################################################
p1=0.7;p2=0.2
pob.a <- data.frame(matrix(rbinom(60,1,p1),10,6))
pob.b <- data.frame(matrix(rbinom(60,1,p2),10,6))
names(pob.a)<-paste("v", 1:6, sep="")
row.names(pob.a)<-paste("Ind", 1:10, sep=" ")
names(pob.b)<-paste("v", 1:6, sep="")
row.names(pob.b)<-paste("Ind", 1:10, sep=" ")
pob.a;pob.b


###################################################
### chunk number 5: 5.volados_dos_hipótesis
###################################################
h1 <- dbinom(2,10, p = 0.3)

h2 <- dbinom(2,10, p = 0.5)
h1;h2
f.ev <- h1/h2; f.ev


###################################################
### chunk number 6: 6.curva_verosimilitud
###################################################
curve(dbinom(2, 10, p = x), from = 0, to = 1)


###################################################
### chunk number 7: 
###################################################
vpar <- seq(0,1,length=1000)
y <- dbinom(2,10,vpar)
y.max<-max(y)
vpar.mle<-vpar[y == max(y)]
par(las=1, cex.axis = 0.8)
plot(c(seq(0,1,length=100)), c(seq(0,0.30,length=100)), 
xlab = "Valor del parámetro", ylab = "Verosimilitud", type = "n")
curve(dbinom(2,10,x),0,1, add =T)
lines(c(vpar.mle,vpar.mle), c(0,y.max),col = "darkblue",lty=1, lwd =1)


###################################################
### chunk number 8: 8.IC_confianza
###################################################
a=2;n=10
logistica <- function(x) exp(x)/(1 + exp(x))
logVerNeg <- function(psi) -dbinom(a, size =n, prob = logistica(psi), log =T)
ajust <- optim(par = 0.5, fn = logVerNeg, method = "BFGS", hessian = T)
psi.mle <- ajust$par
psi.se <- sqrt(1/ajust$hessian)
z.crit <- qnorm(0.975)
logistica(psi.mle)
logistica(c(psi.mle -z.crit*psi.se, psi.mle + z.crit*psi.se))


###################################################
### chunk number 9: 9.IC_confianza2
###################################################
library(bbmle)
logVerNeg <- function(psi) -dbinom(k, size = n, prob = logistica(psi), log =T)
parnames(logVerNeg) <- "psi"
ajust2 <- mle2(logVerNeg, start = c(psi = 0.5), data = list(k=8, n =40))
logistica(ajust2@coef)
logistica(confint(ajust2))


